import React from "react";
import { FiArrowDownRight } from "react-icons/fi";

const WhyUs = () => {
  return (
    <div className="box">
      <div className="container p-5 row">
        <div className="col-md-3 tomato text-white d-flex flex-column justify-content-between align-items-end">
          <h3 className="p-4">Why you should trust us?</h3>
          <FiArrowDownRight size="150" />
        </div>
        <div className="col-md-9 px-5 py-3">
          <div className="list">
            <h6 className="fw-bold subtitle"> Top Rated Developers</h6>
            <p className="xs my-1">
              Our team comprises top-rated developers who excel in their
              respective fields. With a proven track record of delivering
              high-quality solutions, we bring expertise and excellence to every
              project we undertake.
            </p>
          </div>
          <div className="list">
            <h6 className="fw-bold subtitle">Faster Delivery</h6>
            <p className="xs my-1">
              We understand the importance of deadlines. With our efficient
              project management practices and streamlined development
              processes, we guarantee timely delivery without compromising on
              quality. You can trust us to meet your project milestones and
              deliver results on time, every time.
            </p>
          </div>
          <div className="list">
            <h6 className="fw-bold subtitle">Transparent Communication</h6>
            <p className="xs my-1">
              Communication is key to successful collaboration. We believe in
              transparent and open communication channels, keeping you informed
              and involved at every stage of the development process. You'll
              have full visibility into the progress of your project and can
              provide feedback or make suggestions as needed.
            </p>
          </div>
          <div className="list">
            <h6 className="fw-bold subtitle">Proven Track Record</h6>
            <p className="xs my-1">
              We understand the importance of deadlines. With our efficient
              project management practices and streamlined development
              processes, we guarantee timely delivery without compromising on
              quality. You can trust us to meet your project milestones and
              deliver results on time, every time.
            </p>
          </div>
        </div>
      </div>
    </div>
  );
};

export default WhyUs;
