import React from "react";
import { FiAlertTriangle, FiHeadphones, FiKey, FiTarget } from "react-icons/fi";

const ServiceTile = ({ icon, title, description, color }) => (
  <div className={`tile ${color}`}>
    {icon}
    <h6 className="fw-bolder">{title}</h6>
    <p className="xs">{description}</p>
  </div>
);

export default function Services() {
  return (
    <div>
      <div className="py-1 container" id="services">
        <h4 className="fw-bolder text-center">Our Cloud Capabilities</h4>
        <p className="subtitle text-center">
          We offer Cloud & DevOps services on all leading Cloud Platforms
        </p>
        <h6 className="text-justify p-5">
          At Cloudops Innovation, we support a diverse range of cutting-edge
          cloud platforms and services to drive innovation, scalability, and
          efficiency for your business. From industry giants like Amazon Web
          Services (AWS), Microsoft Azure, and Google Cloud Platform (GCP), to
          specialized providers like DigitalOcean and Red Hat OpenShift, we
          offer a comprehensive suite of solutions tailored to your specific
          needs. Whether you're looking to modernize your IT infrastructure with
          VMware Cloud or accelerate application development with Salesforce
          Cloud, our portfolio includes the latest technologies to help you stay
          ahead in today's competitive landscape. With our expertise and
          support, you can harness the power of the cloud to transform your
          business and unlock new opportunities for growth and success.
        </h6>
        <div className="d-flex flex-wrap justify-content-center mt-5 align-items-center">
          <img
            className="cards"
            src="https://pendulum-it.com/wp-content/uploads/2020/05/Google-Cloud-Platform-GCP-logo.png"
            alt="company"
          />
          <img
            className="cards"
            src="https://www.incredibuild.com/wp-content/uploads/2020/09/azure_devops-1.png"
            alt="company"
          />
          <img
            className="cards"
            src="https://logowik.com/content/uploads/images/git6963.jpg"
            alt="company"
          />
          <img
            className="cards"
            src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQR-YeNvO24J4MpxQtUvcegDf33mf_0lZVLwV94b1e8&s"
            alt="company"
          />
          <img
            className="cards"
            src="https://upload.wikimedia.org/wikipedia/commons/thumb/f/ff/DigitalOcean_logo.svg/1200px-DigitalOcean_logo.svg.png"
            alt="company"
          />
          <img
            className="cards"
            src="https://cdn.icon-icons.com/icons2/2389/PNG/512/cisco_logo_icon_145406.png"
            alt="company"
          />
          <img
            className="cards"
            src="https://www.openvirtualization.pro/wp-content/uploads/2019/04/OpenShift-1200x780-699x454.png"
            alt="company"
          />
          <img
            className="cards"
            src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRfDPsHMyPzZ3OBpaSVaCwy6OdwsEMbpg_l6n2HH8gGxA&s"
            alt="company"
          />
          <img
            className="cards"
            src="https://logowik.com/content/uploads/images/jenkins8460.jpg"
            alt="company"
          />
        </div>
      </div>
      <div className="p-5 ht">
        <div className="bg-dark col-md-6 text-white p-5">
          <h4 className="fw-bolder">
            Leverage our expertise in Cloud & DevOps!
          </h4>
          <div className="btns mt-5">Talk to our Experts</div>
        </div>
      </div>
      <div>
        <h3 className="container text-center fw-bolder my-5 p-5">
          Here are the reason why business leaders choose us again and again.
        </h3>
        <div className="d-flex justify-content-center align-items-center flex-wrap mb-5">
          <ServiceTile
            icon={<FiAlertTriangle className="mb-5" size="30" />}
            title="Emergency Support"
            description="When an emergency strikes, you can't afford to wait. Our dedicated team of experts is available 24/7 to respond swiftly to your call for help. Whether it's a technical issue, a critical incident, or any other emergency situation, we're here to spring into action and resolve the problem with speed and efficiency."
            color="green"
          />
          <ServiceTile
            icon={<FiHeadphones className="mb-5" size="30" />}
            title="Clear Communication"
            description="In times of crisis, clear communication is essential. We'll keep you informed every step of the way, providing regular updates on the status of the situation and the progress of our response efforts. You'll have direct access to our team throughout the process, ensuring transparency, trust, and confidence in our services."
            color="orange"
          />
          <ServiceTile
            icon={<FiKey className="mb-5" size="30" />}
            title="Privacy and Security"
            description="We understand the importance of privacy and security. Our team is dedicated to ensuring your data and systems are protected at all times. We implement the latest security measures and protocols to safeguard your information and maintain compliance with industry standards and regulations."
            color="blue"
          />
          <ServiceTile
            icon={<FiTarget className="mb-5" size="30" />}
            title="Tailored Solution"
            description="Every emergency is unique, and so are our solutions. We understand that one size doesn't fit all, which is why we take a personalized approach to every situation. Whether you need on-site assistance, remote support, or a combination of both, we'll work closely with you to develop a tailored plan that meets your specific needs and requirements."
            color="tomato"
          />
        </div>
      </div>
    </div>
  );
}
