import React, { useState } from "react";
import { FiMail } from "react-icons/fi";

const Menu = () => {
  const [isOpen, setIsOpen] = useState(false);

  return (
    <div className="p-3 position-relative d-flex justify-content-between align-items-center">
      <img
        className="logo"
        src="https://cloudopsinnovation.com/static/media/logo.e9225a7d2c9cdc7525c4.png"
        alt="logo"
      />
      <div className="menu-toggle" onClick={() => console.log("testing")}>
        {<FiMail />}
      </div>
      <ul className={`menu-items ${isOpen ? "open" : ""}`}>
        <a href="#home">
          <li>Home</li>
        </a>
        <a href="#services">
          <li>Services</li>
        </a>
        <a href="#contact">
          <li>Contact</li>
        </a>
      </ul>
    </div>
  );
};

export default Menu;
