import React from "react";
import { FiFacebook, FiGithub, FiInstagram, FiMail } from "react-icons/fi";

export default function Footer() {
  return (
    <div className="bg text-white ">
      <div className="pt-1 d-flex flex-wrap">
        <div className="p-5 col-md-4" id="contact">
          <h3 className="fw-bolder">Cloudops Innovation</h3>
          <p className="xs">
            At CloudOps Innovation, we're dedicated to revolutionizing the way
            businesses operate in the cloud. Our innovative solutions empower
            organizations to optimize performance, enhance security, and drive
            growth in today's digital landscape.
          </p>
          <div className="d-flex mt-4 align-items-center">
            <FiInstagram />
            <FiFacebook className="mx-3" />
            <FiGithub className="mx-2" />
            <FiMail className="mx-3" />
          </div>
        </div>
        <div className="p-5 col-md-8" id="contact">
          <h3 className="fw-bolder">Let's connect</h3>
          <p className="subtitle">
            At CloudOps Innovation, we're dedicated to revolutionizing the way
            businesses operate in the cloud. Our innovative solutions empower
            organizations to optimize performance, enhance security, and drive
            growth in today's digital landscape.
          </p>
          <div className="btns">Connect now</div>
        </div>
      </div>
      <div className="p-4 bg-dark mt-5 d-flex justify-content-center align-items-center">
        <span className="xs">Copyright &copy; 2024 | </span>
        <span className="xs mx-1">All rights reserved.</span>
      </div>
    </div>
  );
}
