import React from "react";
import Company from "./Company";
import { FiAward, FiSettings } from "react-icons/fi";
import { FiFacebook, FiGithub, FiInstagram, FiMail } from "react-icons/fi";

export default function Banner() {
  return (
    <div className="container">
      <div className="mt-5">
        <h1 className="fw-bolder">Cloudops Innovation</h1>
        <p>
          Unlock the potential of cloud systems with CloudOps Innovation. We
          simplify the complexities, offering strategic cloud operations for
          your business. Our revolutionary solutions integrate automation,
          scalability, and intelligent insights, empowering you to thrive in the
          dynamic digital landscape. aliquip ex ea commodo consequat."
        </p>
      </div>
      <div className="d-flex flex-wrap justify-content-between align-items-center">
        <div className="d-flex">
          <div className="blue tag">
            <span className="text-dark subtitle">120+ Clients Served</span>
          </div>
          <div className="tomato tag">
            <span className="text-white subtitle">9000+ Hrs. Billed</span>
          </div>
        </div>
        <div className="d-flex mt-4 align-items-center justify-content-end">
          <FiInstagram className="mx-3" />
          <FiFacebook className="mx-3" />
          <FiGithub className="mx-3" />
          <FiMail className="mx-3" />
        </div>
      </div>
      <div className="d-flex flex-wrap mt-4">
        <div className="d-flex align-items-center gray">
          <FiAward size="24" color="#999" />
          <span className="xs px-1">
            Top profile in Upwork in AWS services.
          </span>
        </div>
        <div className="d-flex align-items-center gray">
          <FiSettings size="24" color="#999" />
          <span className="xs px-1">Round the clock maintenance promised.</span>
        </div>
      </div>
      <hr></hr>
      <Company />
    </div>
  );
}
